/******************************************************************************
 * Copyright (c) 1996 Netscape Communications. All rights reserved.
 ******************************************************************************/
/*
 * UnixShell.c
 *
 * Netscape Client Plugin API
 * - Function that need to be implemented by plugin developers
 *
 * This file defines a "Template" plugin that plugin developers can use
 * as the basis for a real plugin.  This shell just provides empty
 * implementations of all functions that the plugin can implement
 * that will be called by Netscape (the NPP_xxx methods defined in 
 * npapi.h). 
 *
 * dp Suresh <dp@netscape.com>
 *
 */

/* The audio/basic SGI plugin part is Written by Ch. Tronche (http://tronche.lri.fr:8000/)
 * Copyright by the author. This is unmaintained, no-warranty free software.
 * Please use freely. It is appreciated (but by no means mandatory) to
 * acknowledge the author's contribution. Thank you.
 * Started on Tue Mar 18 22:33:12 1997 
 */

#include <audio.h>
#include <bstring.h>
#include <stdio.h>

#define XP_UNIX 1

#include "npapi.h"

/***********************************************************************
 * Instance state information about the plugin.
 *
 * PLUGIN DEVELOPERS:
 *	Use this struct to hold per-instance information that you'll
 *	need in the various functions in this file.
 ***********************************************************************/

typedef struct _PluginInstance
{
  ALport _audioport;
  char _fileHeader[24];  /* Buffer to hold the header */
  unsigned long _dataLocation;
} PluginInstance;


/***********************************************************************
 *
 * Empty implementations of plugin API functions
 *
 * PLUGIN DEVELOPERS:
 *	You will need to implement these functions as required by your
 *	plugin.
 *
 ***********************************************************************/

char*
NPP_GetMIMEDescription(void)
{
	return("audio/basic:.au:Sun audio file");
}

NPError
NPP_GetValue(void *future, NPPVariable variable, void *value)
{
	NPError err = NPERR_NO_ERROR;

	switch (variable) {
		case NPPVpluginNameString:
			*((char **)value) = "audio/basic SGI plugin";
			break;
		case NPPVpluginDescriptionString:
			*((char **)value) =
				"audio/basic stream SGI plugin by Ch. Tronche "
			  "(<A HREF=\"http://tronche.lri.fr:8000/internet/plugins/sgi-audio-basic/\">more info</A>).";
			break;
		default:
			err = NPERR_GENERIC_ERROR;
	}
	return err;
}

NPError
NPP_Initialize(void)
{
    return NPERR_NO_ERROR;
}


jref
NPP_GetJavaClass()
{
    return NULL;
}

void
NPP_Shutdown(void)
{
}


NPError 
NPP_New(NPMIMEType pluginType,
	NPP instance,
	uint16 mode,
	int16 argc,
	char* argn[],
	char* argv[],
	NPSavedData* saved)
{
        PluginInstance* This;

	if (instance == NULL)
		return NPERR_INVALID_INSTANCE_ERROR;
		
	instance->pdata = NPN_MemAlloc(sizeof(PluginInstance));
	
	This = (PluginInstance*) instance->pdata;

	if (This != NULL) {

	  This -> _dataLocation = 0;

	  return NPERR_NO_ERROR;
	} else
	  return NPERR_OUT_OF_MEMORY_ERROR;
}


NPError 
NPP_Destroy(NPP instance, NPSavedData** save)
{
	PluginInstance* This;

	if (instance == NULL)
		return NPERR_INVALID_INSTANCE_ERROR;

	This = (PluginInstance*) instance->pdata;

	/* PLUGIN DEVELOPERS:
	 *	If desired, call NP_MemAlloc to create a
	 *	NPSavedDate structure containing any state information
	 *	that you want restored if this plugin instance is later
	 *	recreated.
	 */

	if (This != NULL) {
	  assert(!ALcloseport(This -> _audioport));
	  NPN_MemFree(instance->pdata);
	  instance->pdata = NULL;
	}

	return NPERR_NO_ERROR;
}



NPError 
NPP_SetWindow(NPP instance, NPWindow* window)
{
	PluginInstance* This;

	if (instance == NULL)
		return NPERR_INVALID_INSTANCE_ERROR;

	if (window == NULL)
		return NPERR_NO_ERROR;

	This = (PluginInstance*) instance->pdata;

	/*
	 * PLUGIN DEVELOPERS:
	 *	Before setting window to point to the
	 *	new window, you may wish to compare the new window
	 *	info to the previous window (if any) to note window
	 *	size changes, etc.
	 */

	return NPERR_NO_ERROR;
}


NPError 
NPP_NewStream(NPP instance,
			  NPMIMEType type,
			  NPStream *stream, 
			  NPBool seekable,
			  uint16 *stype)
{
	NPByteRange range;
	PluginInstance* This;

	if (instance == NULL)
		return NPERR_INVALID_INSTANCE_ERROR;

	This = (PluginInstance*) instance->pdata;

	return NPERR_NO_ERROR;
}


/* PLUGIN DEVELOPERS:
 *	These next 2 functions are directly relevant in a plug-in which
 *	handles the data in a streaming manner. If you want zero bytes
 *	because no buffer space is YET available, return 0. As long as
 *	the stream has not been written to the plugin, Navigator will
 *	continue trying to send bytes.  If the plugin doesn't want them,
 *	just return some large number from NPP_WriteReady(), and
 *	ignore them in NPP_Write().  For a NP_ASFILE stream, they are
 *	still called but can safely be ignored using this strategy.
 */

int32 STREAMBUFSIZE = 0X0FFFFFFF; /* If we are reading from a file in NPAsFile
				   * mode so we can take any size stream in our
				   * write call (since we ignore it) */

int32 
NPP_WriteReady(NPP instance, NPStream *stream)
{
	PluginInstance* This;
	if (instance != NULL)
		This = (PluginInstance*) instance->pdata;
	
	return STREAMBUFSIZE;
}

/* The real stuff. Done the quick-and-dirty way, I'm not proud of it. */

#define ERROR(s) { fprintf(stderr, "audio/basic plugin error: %s (line %d in file %s)\n", s, __LINE__, __FILE__); return -1; }

int32 
NPP_Write(NPP instance, NPStream *stream, int32 offset, int32 len, void *buffer)
{
  int32 l = len;
	if (instance != NULL)
	{
		PluginInstance* This = (PluginInstance*) instance->pdata;

		/* Try to get the full header */

		if (offset < 24) {
		  unsigned toCopy = 24 - offset;
		  if (l < toCopy)
			toCopy = l;
		  bcopy(buffer, This -> _fileHeader + offset, toCopy);

		  /* If we get the full header, parse it */

		  if (offset + toCopy >= 24) {

			unsigned frequency, dataFormat;
			long buffer[2];
			ALconfig audioconfig;

			char *p = This -> _fileHeader;
			if (strcmp(p, ".snd"))
			  ERROR("file hasn't the .snd magic number");
			p += 4;

			This -> _dataLocation = ((p[0] * 256 + p[1]) * 256 + p[2]) * 256 + p[3];
			p += 4;

			p += 4; /* We don't care about the data size */

			dataFormat = p[3];

			if (p[0] || p[1] || p[2] || (dataFormat != 1 && dataFormat != 2))
			  ERROR("file isn't of supported Sun audio file format 1 or 2");
			p += 4;

			if (p[0] || p[1])
			  ERROR("sample frequency > 64 kHz ???");
			frequency = p[2] * 256 + p[3];

			buffer[0] = AL_INPUT_RATE;
			buffer[1] = frequency;
			if (ALsetparams(AL_DEFAULT_DEVICE, buffer, 2))
			  ERROR("Can't set sample rate");
			p += 4;

			if (p[0] || p[1] || p[2] || p[3] != 1)
			  ERROR("More than one channel (unsupported)");

			/* Set audio parameter */

			ALseterrorhandler(NULL); 
			audioconfig = ALnewconfig(); 
			assert(audioconfig);

			if (dataFormat == 2)
			  assert(!ALsetsampfmt(audioconfig, AL_SAMPFMT_TWOSCOMP)); 
			assert(!ALsetwidth(audioconfig, AL_SAMPLE_8));
			assert(!ALsetchannels(audioconfig,AL_MONO));

			This -> _audioport = ALopenport("toto", "w", audioconfig);
			assert(This -> _audioport);
			assert(!ALfreeconfig(audioconfig));

		  }
		  offset += toCopy;
		  buffer += toCopy;
		  l -= toCopy;
		}

		/* Skip the info string */

		if (offset < This -> _dataLocation) {
		  unsigned toSkip = This -> _dataLocation - offset;
		  if (toSkip > l)
			toSkip = l;
		  buffer += toSkip;
		  l -= toSkip;
		}

		/* Real work */

		if (ALwritesamps(This -> _audioport, buffer, l))
		  ERROR("error while writing audio samples");
	}

	return len;		/* The number of bytes accepted */
}


NPError 
NPP_DestroyStream(NPP instance, NPStream *stream, NPError reason)
{
	PluginInstance* This;

	if (instance == NULL)
		return NPERR_INVALID_INSTANCE_ERROR;
	This = (PluginInstance*) instance->pdata;

	return NPERR_NO_ERROR;
}


void 
NPP_StreamAsFile(NPP instance, NPStream *stream, const char* fname)
{
	PluginInstance* This;
	if (instance != NULL)
		This = (PluginInstance*) instance->pdata;
}


void 
NPP_Print(NPP instance, NPPrint* printInfo)
{
	if(printInfo == NULL)
		return;

	if (instance != NULL) {
		PluginInstance* This = (PluginInstance*) instance->pdata;
	
		if (printInfo->mode == NP_FULL) {
		    /*
		     * PLUGIN DEVELOPERS:
		     *	If your plugin would like to take over
		     *	printing completely when it is in full-screen mode,
		     *	set printInfo->pluginPrinted to TRUE and print your
		     *	plugin as you see fit.  If your plugin wants Netscape
		     *	to handle printing in this case, set
		     *	printInfo->pluginPrinted to FALSE (the default) and
		     *	do nothing.  If you do want to handle printing
		     *	yourself, printOne is true if the print button
		     *	(as opposed to the print menu) was clicked.
		     *	On the Macintosh, platformPrint is a THPrint; on
		     *	Windows, platformPrint is a structure
		     *	(defined in npapi.h) containing the printer name, port,
		     *	etc.
		     */

			void* platformPrint =
				printInfo->print.fullPrint.platformPrint;
			NPBool printOne =
				printInfo->print.fullPrint.printOne;
			
			/* Do the default*/
			printInfo->print.fullPrint.pluginPrinted = FALSE;
		}
		else {	/* If not fullscreen, we must be embedded */
		    /*
		     * PLUGIN DEVELOPERS:
		     *	If your plugin is embedded, or is full-screen
		     *	but you returned false in pluginPrinted above, NPP_Print
		     *	will be called with mode == NP_EMBED.  The NPWindow
		     *	in the printInfo gives the location and dimensions of
		     *	the embedded plugin on the printed page.  On the
		     *	Macintosh, platformPrint is the printer port; on
		     *	Windows, platformPrint is the handle to the printing
		     *	device context.
		     */

			NPWindow* printWindow =
				&(printInfo->print.embedPrint.window);
			void* platformPrint =
				printInfo->print.embedPrint.platformPrint;
		}
	}
}
